-- Add payment fields to orders table for toyyibPay integration
ALTER TABLE orders 
ADD COLUMN payment_status VARCHAR(20) DEFAULT 'pending' AFTER status,
ADD COLUMN payment_reference VARCHAR(100) NULL AFTER payment_status,
ADD COLUMN payment_amount DECIMAL(10,2) NULL AFTER payment_reference,
ADD COLUMN payment_date DATETIME NULL AFTER payment_amount,
ADD COLUMN bill_code VARCHAR(50) NULL AFTER payment_date,
ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER created_at;

-- Add index for better performance
CREATE INDEX idx_orders_payment_status ON orders(payment_status);
CREATE INDEX idx_orders_bill_code ON orders(bill_code);
CREATE INDEX idx_orders_payment_reference ON orders(payment_reference);