-- Add sale and flash sale fields to products table
-- Run this SQL script to add the new sale fields

USE perfume_store;

-- Add sale-related fields to products table
ALTER TABLE products 
ADD COLUMN sale_price DECIMAL(10,2) NULL AFTER price,
ADD COLUMN is_on_sale BOOLEAN DEFAULT FALSE AFTER sale_price,
ADD COLUMN sale_start_date DATETIME NULL AFTER is_on_sale,
ADD COLUMN sale_end_date DATETIME NULL AFTER sale_start_date,
ADD COLUMN is_flash_sale BOOLEAN DEFAULT FALSE AFTER sale_end_date,
ADD COLUMN flash_sale_duration_hours INT DEFAULT 24 AFTER is_flash_sale,
ADD COLUMN flash_sale_started_at DATETIME NULL AFTER flash_sale_duration_hours;

-- Add indexes for better performance
CREATE INDEX IF NOT EXISTS idx_products_sale ON products(is_on_sale);
CREATE INDEX IF NOT EXISTS idx_products_flash_sale ON products(is_flash_sale);
CREATE INDEX IF NOT EXISTS idx_products_sale_dates ON products(sale_start_date, sale_end_date);