<?php
// Get order items for this order
$order_items = $order_model->getOrderItems($order['id']);
$shipping_address = json_decode($order['shipping_address'], true);
?>
<div class="order-card">
    <div class="order-header">
        <div>
            <div class="order-number">Order #<?php echo $order['order_number']; ?></div>
            <div class="order-date"><?php echo date('M j, Y', strtotime($order['created_at'])); ?></div>
        </div>
        <span class="order-status status-<?php echo $order['status']; ?>">
            <i class="fas fa-<?php 
                switch($order['status']) {
                    case 'pending': echo 'clock'; break;
                    case 'awaiting_payment': echo 'wallet'; break;
                    case 'processing': echo 'cog'; break;
                    case 'shipped': echo 'truck'; break;
                    case 'delivered': echo 'check-circle'; break;
                    case 'cancelled': echo 'times'; break;
                    default: echo 'question';
                }
            ?>"></i>
            <?php 
                switch($order['status']) {
                    case 'awaiting_payment': echo 'Awaiting Payment'; break;
                    case 'pending': echo 'Pending'; break;
                    case 'processing': echo 'Processing'; break;
                    case 'shipped': echo 'Shipped'; break;
                    case 'delivered': echo 'Delivered'; break;
                    case 'cancelled': echo 'Cancelled'; break;
                    default: echo ucfirst($order['status']);
                }
            ?>
        </span>
    </div>

    <div class="order-items">
        <?php foreach ($order_items as $item): ?>
        <div class="order-item">
            <div class="item-image">
                <?php if (!empty($item['product_image'])): ?>
                    <img src="<?php echo htmlspecialchars($item['product_image']); ?>" alt="Product" style="width:100%;height:100%;object-fit:cover;border-radius:8px;">
                <?php else: ?>
                    <i class="fas fa-box"></i>
                <?php endif; ?>
            </div>
            <div class="item-details">
                <div class="item-name"><?php echo htmlspecialchars($item['product_name']); ?></div>
                <div class="item-size">
                    <?php if (!empty($item['version'])): ?>
                        Version: <?php echo htmlspecialchars($item['version']); ?> | 
                    <?php endif; ?>
                    <?php echo htmlspecialchars($item['size'] ?? 'Standard'); ?>
                </div>
            </div>
            <div class="item-quantity">Qty: <?php echo $item['quantity']; ?></div>
        </div>
        <?php endforeach; ?>
    </div>

    <div class="order-total">
        <span class="total-label">Total Amount</span>
        <span class="total-amount">RM <?php echo number_format($order['total_amount'], 2); ?></span>
    </div>

    <?php if (!empty($order['tracking_number'])): ?>
    <div class="tracking-number-section">
        <div class="tracking-number-label">
            <i class="fas fa-shipping-fast"></i>
            Tracking Number
        </div>
        <div class="tracking-number-value"><?php echo htmlspecialchars($order['tracking_number']); ?></div>
    </div>
    <?php endif; ?>

    <?php if (in_array($order['status'], ['processing', 'shipped'])): ?>
    <div class="tracking-section">
        <div class="tracking-title">
            <i class="fas fa-route"></i>
            Tracking Progress
        </div>
        <div class="tracking-steps">
            <div class="tracking-step">
                <div class="step-icon completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-content">
                    <div class="step-title">Order Placed</div>
                    <div class="step-date"><?php echo date('M j, Y g:i A', strtotime($order['created_at'])); ?></div>
                </div>
                <div class="tracking-line"></div>
            </div>
            
            <div class="tracking-step">
                <div class="step-icon <?php echo $order['status'] === 'processing' ? 'current' : 'completed'; ?>">
                    <i class="fas fa-<?php echo $order['status'] === 'processing' ? 'clock' : 'check'; ?>"></i>
                </div>
                <div class="step-content">
                    <div class="step-title">Processing</div>
                    <div class="step-date">
                        <?php if ($order['status'] === 'processing'): ?>
                            In Progress
                        <?php else: ?>
                            <?php echo date('M j, Y g:i A', strtotime($order['updated_at'])); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="tracking-line"></div>
            </div>
            
            <?php if ($order['status'] === 'shipped'): ?>
            <div class="tracking-step">
                <div class="step-icon current">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="step-content">
                    <div class="step-title">Shipped</div>
                    <div class="step-date"><?php echo date('M j, Y g:i A', strtotime($order['updated_at'])); ?></div>
                </div>
                <div class="tracking-line"></div>
            </div>
            <?php endif; ?>
            
            <?php if ($order['status'] === 'delivered'): ?>
            <div class="tracking-step">
                <div class="step-icon completed">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="step-content">
                    <div class="step-title">Delivered</div>
                    <div class="step-date"><?php echo date('M j, Y g:i A', strtotime($order['updated_at'])); ?></div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="action-buttons">
        <?php if (in_array($order['status'], ['processing', 'shipped'])): ?>
            <button class="btn-track" onclick="markDeliverySuccess(<?php echo $order['id']; ?>)">
                <i class="fas fa-check-circle"></i> Delivery Successfully
            </button>
        <?php endif; ?>
        
        <button class="btn-details" onclick="viewOrderDetails(<?php echo $order['id']; ?>)">
            <i class="fas fa-eye"></i> View Details
        </button>
    </div>
</div>