<div class="new-arrival-card <?php echo $product['is_out_of_stock'] ? 'out-of-stock' : ''; ?>" data-product-id="<?php echo $product['id']; ?>" onclick="viewProduct(<?php echo $product['id']; ?>)">
    <div class="new-arrival-image-container">
        <img src="<?php echo $product['image']; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="new-arrival-image" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwIiBoZWlnaHQ9IjEwMCIgZmlsbD0iI2Y0ZjRmNCIvPjx0ZXh0IHg9IjUwIiB5PSI1MCIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5IiB0ZXh0LWFuY2hvcj0ibWlkZGxlIj5JbWFnZTwvdGV4dD48L3N2Zz4='">

        <!-- Flash Sale Badge -->
        <?php if (isset($product['is_flash_sale_active']) && $product['is_flash_sale_active']): ?>
            <div class="flash-sale-badge">
                <i class="fas fa-bolt"></i>
                <span>FLASH SALE</span>
            </div>
        <?php elseif (isset($product['sale_active']) && $product['sale_active']): ?>
            <div class="sale-badge">
                <i class="fas fa-tag"></i>
                <span>SALE</span>
            </div>
        <?php endif; ?>

        <?php if ($product['is_out_of_stock']): ?>
            <div class="out-of-stock-overlay">
                <span>Out of Stock</span>
                <?php if (!empty($product['restock_date'])): ?>
                    <div class="restock-timer" data-restock-date="<?php echo $product['restock_date']; ?>">
                        Back in stock in: <span class="timer-days">00</span>d <span class="timer-hours">00</span>h <span class="timer-minutes">00</span>m
                    </div>
                <?php elseif (!empty($product['restock_message'])): ?>
                    <div class="restock-message">
                        <?php echo htmlspecialchars($product['restock_message']); ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="new-arrival-info">
        <div class="new-arrival-price">
            <?php 
            // Check if product has flash sale variations
            $hasFlashSaleVariations = isset($product['flash_sale_variations_detail']) && !empty($product['flash_sale_variations_detail']);
            $showSalePrice = false;
            $salePrice = 0;
            $originalPrice = 0;
            
            if ($hasFlashSaleVariations) {
                // Get the first variation's prices for display
                $firstVariation = $product['flash_sale_variations_detail'][0];
                $salePrice = $firstVariation['sale_price'];
                $originalPrice = $firstVariation['original_price'];
                $showSalePrice = true;
            } elseif (isset($product['sale_active']) && $product['sale_active'] && isset($product['sale_price']) && isset($product['min_price'])) {
                $salePrice = $product['sale_price'];
                $originalPrice = $product['min_price'];
                $showSalePrice = true;
            }
            ?>
            
            <?php if ($showSalePrice): ?>
                <div class="price-container">
                    <span class="sale-price">RM <?php echo number_format($salePrice, 2); ?></span>
                    <span class="original-price">RM <?php echo number_format($originalPrice, 2); ?></span>
                </div>
            <?php else: ?>
                <span class="current-price"><?php echo $product['price_range']; ?></span>
            <?php endif; ?>
        </div>
        <?php 
        $nameRaw = $product['name'] ?? '';
        $nameEsc = htmlspecialchars($nameRaw);
        if (function_exists('mb_strlen') && function_exists('mb_substr')) {
            $displayName = (mb_strlen($nameRaw, 'UTF-8') > 15)
                ? htmlspecialchars(mb_substr($nameRaw, 0, 15, 'UTF-8')) . '…'
                : $nameEsc;
        } else {
            $displayName = (strlen($nameRaw) > 15)
                ? htmlspecialchars(substr($nameRaw, 0, 15)) . '…'
                : $nameEsc;
        }
        ?>
        <h3 class="new-arrival-name" title="<?php echo $nameEsc; ?>"><?php echo $displayName; ?></h3>
        <p class="new-arrival-volume">
            <?php if (!empty($product['variations_detail'])): ?>
                <?php
                $first = $product['variations_detail'][0];
                $label = trim(($first['version_type'] ?? '') . (isset($first['size']) ? ' - ' . $first['size'] : ''));
                // Truncate the label to keep it compact
                if (function_exists('mb_strlen') && function_exists('mb_substr')) {
                    $displayLabel = (mb_strlen($label, 'UTF-8') > 20)
                        ? htmlspecialchars(mb_substr($label, 0, 20, 'UTF-8')) . '…'
                        : htmlspecialchars($label);
                } else {
                    $displayLabel = (strlen($label) > 20)
                        ? htmlspecialchars(substr($label, 0, 20)) . '…'
                        : htmlspecialchars($label);
                }
                echo $displayLabel;
                ?>
                <?php if (count($product['variations_detail']) > 1): ?>
                    <span class="more-variations">+<?php echo count($product['variations_detail']) - 1; ?> more</span>
                <?php endif; ?>
            <?php else: ?>
                No variations
            <?php endif; ?>
        </p>
    </div>
</div>