<div class="product-list-item <?php echo $product['is_out_of_stock'] ? 'out-of-stock' : ''; ?>" 
     data-product-id="<?php echo $product['id']; ?>" 
     <?php if (!$product['is_out_of_stock']): ?>onclick="viewProduct(<?php echo $product['id']; ?>)"<?php endif; ?>>
    
    <div class="list-item-content">
        <div class="list-item-info">
            <h3 class="list-item-name" title="<?php echo htmlspecialchars($product['name']); ?>">
                <?php echo htmlspecialchars($product['name']); ?>
            </h3>
            
            <p class="list-item-volume">
                <?php if (!empty($product['variations_detail'])): ?>
                    <?php
                    $first = $product['variations_detail'][0];
                    $label = trim(($first['version_type'] ?? '') . (isset($first['size']) ? ' - ' . $first['size'] : ''));
                    echo htmlspecialchars($label);
                    ?>
                    <?php if (count($product['variations_detail']) > 1): ?>
                        <span class="more-variations">+<?php echo count($product['variations_detail']) - 1; ?> more</span>
                    <?php endif; ?>
                <?php else: ?>
                    No variations
                <?php endif; ?>
            </p>
        </div>
        
        <div class="list-item-price">
            <?php 
            // Check if product has flash sale variations
            $hasFlashSaleVariations = isset($product['flash_sale_variations_detail']) && !empty($product['flash_sale_variations_detail']);
            $showSalePrice = false;
            $salePrice = 0;
            $originalPrice = 0;
            
            if ($hasFlashSaleVariations) {
                // Get the first variation's prices for display
                $firstVariation = $product['flash_sale_variations_detail'][0];
                $salePrice = $firstVariation['sale_price'];
                $originalPrice = $firstVariation['original_price'];
                $showSalePrice = true;
            } elseif (isset($product['sale_active']) && $product['sale_active'] && isset($product['sale_price']) && isset($product['min_price'])) {
                $salePrice = $product['sale_price'];
                $originalPrice = $product['min_price'];
                $showSalePrice = true;
            }
            ?>
            
            <?php if ($showSalePrice): ?>
                <div class="price-container">
                    <span class="sale-price">RM <?php echo number_format($salePrice, 2); ?></span>
                    <span class="original-price">RM <?php echo number_format($originalPrice, 2); ?></span>
                </div>
            <?php else: ?>
                <span class="current-price"><?php echo $product['price_range']; ?></span>
            <?php endif; ?>
        </div>
    </div>
    
    <?php if ($product['is_out_of_stock']): ?>
        <div class="list-item-status">
            <span class="out-of-stock-text">Out of Stock</span>
        </div>
    <?php endif; ?>
    
    <!-- Flash Sale Badge for List View -->
    <?php if (isset($product['is_flash_sale_active']) && $product['is_flash_sale_active']): ?>
        <div class="list-flash-sale-badge">
            <i class="fas fa-bolt"></i>
            <span>FLASH SALE</span>
        </div>
    <?php elseif (isset($product['sale_active']) && $product['sale_active']): ?>
        <div class="list-sale-badge">
            <i class="fas fa-tag"></i>
            <span>SALE</span>
        </div>
    <?php endif; ?>
</div>