<?php
/**
 * Remember Me Helper Functions
 * Include this file in pages that need remember me functionality
 */

require_once __DIR__ . '/../models/User.php';

/**
 * Check for remember me token and auto-login user
 * Call this function at the beginning of pages that require authentication
 */
function checkRememberMe() {
    if (!isset($_SESSION['user_id']) && isset($_COOKIE['remember_token'])) {
        $user = new User();
        $user_data = $user->verifyRememberToken($_COOKIE['remember_token']);
        
        if ($user_data) {
            // Auto-login the user
            $_SESSION['user_id'] = $user_data['id'];
            $_SESSION['user_email'] = $user_data['email'];
            $_SESSION['user_name'] = $user_data['first_name'] . ' ' . $user_data['last_name'];
            return true;
        } else {
            // Invalid token, clear the cookie
            setcookie('remember_token', '', time() - 3600, '/', '', false, true);
        }
    }
    return false;
}

/**
 * Clear remember me token and cookie
 * Call this function when user logs out
 */
function clearRememberMe() {
    if (isset($_COOKIE['remember_token'])) {
        $user = new User();
        $user->clearRememberToken($_COOKIE['remember_token']);
        // Clear the cookie
        setcookie('remember_token', '', time() - 3600, '/', '', false, true);
    }
}

/**
 * Clean up expired remember tokens
 * Call this function periodically (e.g., in a cron job)
 */
function cleanupExpiredRememberTokens() {
    $user = new User();
    return $user->cleanupExpiredTokens();
}
?>