<?php
session_start();
require_once 'models/User.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    header('Location: login.php');
    exit();
}

// Get user data
$user = new User();
$user_data = $user->getById($_SESSION['user_id']);

// QR should contain only the user ID (for POS to read)
$qr_data = (string)$_SESSION['user_id'];

if (!$user_data) {
    header('Location: login.php');
    exit();
}

// Handle logout
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - 2 Days Parfume</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php include_once 'includes/appilix-sdk.php'; ?>
    <?php include_once 'includes/appilix-user-identity.php'; ?>
    <script src="script.js" defer></script>
    <style>
        .profile-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding-bottom: 100px;
        }

        .profile-header {
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            padding: 20px 20px 40px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .profile-header::before {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            border-radius: 50% 50% 0 0 / 100% 100% 0 0;
        }

        .profile-picture {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid #D4AF37;
            margin: 0 auto 15px auto;
            position: relative;
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            color: #1A4D2A;
            box-shadow: 0 4px 15px rgba(26, 77, 42, 0.3);
        }

        .profile-picture .camera-icon {
            position: absolute;
            bottom: 5px;
            right: 5px;
            width: 30px;
            height: 30px;
            background: #1A4D2A;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            color: #D4AF37;
            border: 2px solid #D4AF37;
            cursor: pointer;
        }

        .profile-name {
            color: #D4AF37;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .profile-role {
            color: #F4D03F;
            font-size: 16px;
        }

        .profile-content {
            padding: 30px 20px;
            margin-top: -20px;
            position: relative;
            z-index: 2;
        }

        .orders-section {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .section-title {
            font-size: 20px;
            font-weight: bold;
            color: #1A4D2A;
            margin-bottom: 20px;
        }

        .orders-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .order-item {
            text-align: center;
            padding: 15px 10px;
            border-radius: 10px;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .order-item:hover {
            background: #f8f9fa;
            transform: translateY(-2px);
        }

        .order-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            margin: 0 auto 10px auto;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: white;
        }

        .order-icon.pending { background: linear-gradient(135deg, #D4AF37, #F4D03F); }
        .order-icon.delivered { background: linear-gradient(135deg, #1A4D2A, #2d5a3d); }
        .order-icon.wishlist { background: linear-gradient(135deg, #e83e8c, #fd7e14); }
        .order-icon.support { background: linear-gradient(135deg, #1A4D2A, #2d5a3d); }
        .order-icon.qr { background: linear-gradient(135deg, #0d6efd, #198754); }

        .order-label {
            font-size: 12px;
            color: #666;
            font-weight: 500;
        }

        .settings-section {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .settings-item {
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .settings-item:last-child {
            border-bottom: none;
        }

        .settings-item:hover {
            background: #f8f9fa;
            margin: 0 -20px;
            padding-left: 20px;
            padding-right: 20px;
            border-radius: 10px;
        }

        .settings-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: #1A4D2A;
            font-size: 16px;
        }

        .settings-text {
            flex: 1;
            font-size: 16px;
            color: #1A4D2A;
            font-weight: 500;
        }

        .settings-arrow {
            color: #D4AF37;
            font-size: 14px;
        }

        .settings-item.delete-account {
            border-bottom: 2px solid #ffebee;
        }

        .settings-item.delete-account:hover {
            background: #ffebee;
            margin: 0 -20px;
            padding-left: 20px;
            padding-right: 20px;
            border-radius: 10px;
        }

        .settings-icon.delete-icon {
            background: linear-gradient(135deg, #f44336, #d32f2f);
        }

        .settings-text.delete-text {
            color: #d32f2f;
            font-weight: 600;
        }

        /* Mobile Modal Styles */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            display: none;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal-overlay.show {
            display: flex;
        }

        .modal-content {
            background: white;
            border-radius: 20px;
            padding: 30px 25px;
            max-width: 400px;
            width: 100%;
            max-height: 80vh;
            overflow-y: auto;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            animation: modalSlideIn 0.3s ease-out;
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px) scale(0.9);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .modal-header {
            text-align: center;
            margin-bottom: 25px;
        }

        .modal-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, #ff6b6b, #ee5a52);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px auto;
            font-size: 24px;
            color: white;
            box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);
        }

        .modal-title {
            font-size: 20px;
            font-weight: bold;
            color: #1A4D2A;
            margin-bottom: 8px;
        }

        .modal-subtitle {
            font-size: 14px;
            color: #666;
        }

        .modal-body {
            margin-bottom: 25px;
        }

        .warning-text {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 14px;
            color: #856404;
            text-align: center;
            font-weight: 600;
        }

        .deletion-list {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .deletion-list h4 {
            font-size: 16px;
            color: #1A4D2A;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .deletion-list ul {
            margin: 0;
            padding-left: 20px;
        }

        .deletion-list li {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }

        .confirmation-input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            font-size: 16px;
            margin-bottom: 20px;
            text-align: center;
            transition: border-color 0.3s ease;
        }

        .confirmation-input:focus {
            outline: none;
            border-color: #D4AF37;
        }

        .confirmation-input.error {
            border-color: #f44336;
            background: #ffebee;
        }

        .modal-actions {
            display: flex;
            gap: 10px;
        }

        .modal-btn {
            flex: 1;
            padding: 12px 20px;
            border: none;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .modal-btn-cancel {
            background: #f8f9fa;
            color: #666;
            border: 2px solid #e9ecef;
        }

        .modal-btn-cancel:hover {
            background: #e9ecef;
            color: #495057;
        }

        .modal-btn-delete {
            background: linear-gradient(135deg, #f44336, #d32f2f);
            color: white;
            box-shadow: 0 4px 15px rgba(244, 67, 54, 0.3);
        }

        .modal-btn-delete:hover {
            background: linear-gradient(135deg, #d32f2f, #b71c1c);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(244, 67, 54, 0.4);
        }

        .modal-btn-delete:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        @media (max-width: 480px) {
            .modal-content {
                margin: 10px;
                padding: 25px 20px;
            }
            
            .modal-actions {
                flex-direction: column;
            }
            
            .modal-btn {
                width: 100%;
            }
        }

        .logout-section {
            text-align: center;
            margin-top: 30px;
            margin-bottom: 20px;
            position: relative;
            z-index: 10;
        }

        .logout-btn {
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
            border: 2px solid #1A4D2A;
            color: #1A4D2A;
            padding: 12px 30px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            position: relative;
            z-index: 10;
            box-shadow: 0 2px 8px rgba(212, 175, 55, 0.3);
        }

        .logout-btn:hover {
            background: linear-gradient(135deg, #1A4D2A, #2d5a3d);
            color: #D4AF37;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(26, 77, 42, 0.4);
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }

        .stat-item {
            background: white;
            border-radius: 10px;
            padding: 15px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .stat-number {
            font-size: 24px;
            font-weight: bold;
            color: #D4AF37;
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 12px;
            color: #1A4D2A;
        }

        .bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 375px;
    background: linear-gradient(135deg, #1A4D2A, #2d5a3d);
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 5px 20px 5px 20px;
    border-top: 3px solid #D4AF37;
    border-radius: 20px 20px 0 0;
    box-shadow: 0 -4px 15px rgba(26, 77, 42, 0.3);
    z-index: 10;
    
}
        @media (max-width: 480px) {
            .orders-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .profile-container {
                padding-bottom: 120px;
            }
        }
    </style>
</head>
<body>
    <div class="profile-container">
        <!-- Top Navigation -->
        <nav class="top-nav">
            <div class="nav-left">
                <i class="fas fa-arrow-left" onclick="goBack()"></i>
            </div>
            <div class="nav-center">
                <div class="logo">
                    <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="logo-img">
                </div>
            </div>
            <div class="nav-right">
                <i class="fas fa-search" onclick="window.location.href='products.php'"></i>
            </div>
        </nav>

        <!-- Profile Header -->
        <div class="profile-header">
            <form id="avatar-form" enctype="multipart/form-data" style="display:none;">
                <input type="file" id="avatar-input" name="avatar" accept="image/*">
            </form>
            <div class="profile-picture" id="profile-picture">
                <?php if (!empty($user_data['avatar'])): ?>
                    <img src="<?php echo htmlspecialchars($user_data['avatar']); ?>" alt="Avatar" style="width:100%;height:100%;object-fit:cover;border-radius:50%;">
                <?php else: ?>
                    <i class="fas fa-user"></i>
                <?php endif; ?>
                <div class="camera-icon" onclick="triggerAvatarUpload()">
                    <i class="fas fa-camera"></i>
                </div>
            </div>
            <div class="profile-name"><?php echo htmlspecialchars($user_data['first_name'] . ' ' . $user_data['last_name']); ?></div>
            <div class="profile-role">Perfume Enthusiast</div>
        </div>

        <!-- Profile Content -->
        <div class="profile-content">

            <!-- My Orders Section -->
            <div class="orders-section">
                <h3 class="section-title">My Orders</h3>
                <div class="orders-grid">
                    <div class="order-item" onclick="viewOrders('pending')">
                        <div class="order-icon pending">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <div class="order-label">Pending Payment</div>
                    </div>
                    <div class="order-item" onclick="window.location.href='delivery-tracking.php'">
                        <div class="order-icon delivered">
                            <i class="fas fa-truck"></i>
                        </div>
                        <div class="order-label">Track Orders</div>
                    </div>
                    <div class="order-item" onclick="window.location.href='favorites.php'">
                        <div class="order-icon wishlist">
                            <i class="fas fa-heart"></i>
                        </div>
                        <div class="order-label">Wishlist</div>
                    </div>
                    <div class="order-item" onclick="contactSupport()">
                        <div class="order-icon support">
                            <i class="fas fa-headset"></i>
                        </div>
                        <div class="order-label">Customer Care</div>
                    </div>
                    <div class="order-item" onclick="openQr()">
                        <div class="order-icon qr">
                            <i class="fas fa-qrcode"></i>
                        </div>
                        <div class="order-label">QR Code</div>
                    </div>
                </div>
            </div>

            <!-- Account Settings Section -->
            <div class="settings-section">
                <h3 class="section-title">Account Settings</h3>
                <div class="settings-item" onclick="editProfile()">
                    <div class="settings-icon">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="settings-text">Edit Profile</div>
                    <div class="settings-arrow">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
                <div class="settings-item" onclick="editAddress()">
                    <div class="settings-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="settings-text">Shipping Address</div>
                    <div class="settings-arrow">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
                <div class="settings-item" onclick="changePassword()">
                    <div class="settings-icon">
                        <i class="fas fa-lock"></i>
                    </div>
                    <div class="settings-text">Change Password</div>
                    <div class="settings-arrow">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
                <div class="settings-item" onclick="notificationSettings()">
                    <div class="settings-icon">
                        <i class="fas fa-bell"></i>
                    </div>
                    <div class="settings-text">Notifications</div>
                    <div class="settings-arrow">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
                <div class="settings-item delete-account" onclick="deleteAccount()">
                    <div class="settings-icon delete-icon">
                        <i class="fas fa-trash"></i>
                    </div>
                    <div class="settings-text delete-text">Delete Account</div>
                    <div class="settings-arrow">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
            </div>

            <!-- Logout Section -->
            <div class="logout-section">
                <button class="logout-btn" onclick="logout()">
                    <i class="fas fa-sign-out-alt"></i>
                    Logout
                </button>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <nav class="bottom-nav">
            <div class="nav-item" onclick="window.location.href='index.php'">
                <i class="fas fa-home"></i>
            </div>
            <div class="nav-item" onclick="window.location.href='products.php'">
                <i class="fas fa-box"></i>
            </div>
            <div class="nav-item" onclick="window.location.href='cart.php'">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="nav-item active">
                <i class="far fa-user"></i>
            </div>
        </nav>

        <!-- Delete Account Modal -->
        <div class="modal-overlay" id="deleteAccountModal">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="modal-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="modal-title">Delete Account</div>
                    <div class="modal-subtitle">This action cannot be undone</div>
                </div>
                
                <div class="modal-body">
                    <div class="warning-text">
                        ⚠️ WARNING: This action cannot be undone!
                    </div>
                    
                    <div class="deletion-list">
                        <h4>Deleting your account will permanently remove:</h4>
                        <ul>
                            <li>All your personal information</li>
                            <li>Order history and tracking data</li>
                            <li>Favorites and wishlist items</li>
                            <li>Shipping addresses</li>
                            <li>Analytics and usage data</li>
                            <li>All other account data</li>
                        </ul>
                    </div>
                    
                    <div>
                        <label for="confirmationInput" style="display: block; margin-bottom: 10px; font-weight: 600; color: #1A4D2A;">
                            Type "DELETE" to confirm:
                        </label>
                        <input type="text" id="confirmationInput" class="confirmation-input" placeholder="Type DELETE here" autocomplete="off">
                    </div>
                </div>
                
                <div class="modal-actions">
                    <button class="modal-btn modal-btn-cancel" onclick="closeDeleteModal()">
                        <i class="fas fa-times"></i>
                        Cancel
                    </button>
                    <button class="modal-btn modal-btn-delete" id="confirmDeleteBtn" onclick="confirmDeleteAccount()" disabled>
                        <i class="fas fa-trash"></i>
                        Delete Account
                    </button>
                </div>
            </div>
        </div>
        
        <!-- QR Modal -->
        <div class="modal-overlay" id="qrModal">
            <div class="modal-content" style="max-width:340px;">
                <div class="modal-header">
                    <div class="modal-icon" style="background:linear-gradient(135deg,#0d6efd,#198754)">
                        <i class="fas fa-qrcode"></i>
                    </div>
                    <div class="modal-title">Membership QR</div>
                    <div class="modal-subtitle">Show this at the counter</div>
                </div>
                <div class="modal-body" style="text-align:center;">
                    <img id="qrImage" alt="QR Code" style="width:220px;height:220px;border-radius:12px;border:2px solid #e9ecef;" />
                    <div style="margin-top:12px;color:#1A4D2A;font-weight:600;">
                        <?php echo htmlspecialchars($user_data['first_name'] . ' ' . $user_data['last_name']); ?>
                    </div>
                </div>
                <div class="modal-actions">
                    <button class="modal-btn modal-btn-cancel" onclick="closeQr()">
                        <i class="fas fa-times"></i>
                        Close
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        const QR_DATA = <?php echo json_encode($qr_data); ?>;

        function goBack() {
            window.history.back();
        }

        function triggerAvatarUpload() {
            document.getElementById('avatar-input').click();
        }

        // Handle file selection and upload
        document.addEventListener('DOMContentLoaded', function() {
            const input = document.getElementById('avatar-input');
            if (!input) return;
            input.addEventListener('change', function() {
                if (!this.files || !this.files[0]) return;
                const formData = new FormData();
                formData.append('avatar', this.files[0]);
                fetch('upload-profile-photo.php', { method: 'POST', body: formData })
                    .then(r => r.json())
                    .then(data => {
                        if (data.success && data.avatar) {
                            const picture = document.getElementById('profile-picture');
                            if (picture) {
                                picture.innerHTML = '<img src="' + data.avatar + '" alt="Avatar" style="width:100%;height:100%;object-fit:cover;border-radius:50%;">' +
                                    '<div class="camera-icon" onclick="triggerAvatarUpload()"><i class="fas fa-camera"></i></div>';
                            }
                            showNotification('Profile photo updated!', 'success');
                        } else {
                            showNotification(data.message || 'Upload failed', 'error');
                        }
                        input.value = '';
                    })
                    .catch(() => {
                        showNotification('Upload failed', 'error');
                        input.value = '';
                    });
            });
        });

        function viewOrders(status) {
            if (status === 'pending') {
                window.location.href = 'pending-payment.php';
            } else {
                // Navigate to delivery tracking page
                window.location.href = 'delivery-tracking.php';
            }
        }

        function editProfile() {
            window.location.href = 'edit-profile.php';
        }

        function editAddress() {
            window.location.href = 'shipping-address.php';
        }

        function changePassword() {
            window.location.href = 'change-password.php';
        }

        function notificationSettings() {
            window.location.href = 'notification-settings.php';
        }

        function contactSupport() {
            window.location.href = 'customer-service.php';
        }

        function logout() {
            if (confirm('Are you sure you want to logout?')) {
                window.location.href = 'profile.php?action=logout';
            }
        }

        function openQr() {
            const modal = document.getElementById('qrModal');
            const img = document.getElementById('qrImage');
            if (img && QR_DATA) {
                const encoded = encodeURIComponent(QR_DATA);
                img.src = 'https://api.qrserver.com/v1/create-qr-code/?size=220x220&data=' + encoded;
            }
            modal.classList.add('show');
        }

        function closeQr() {
            const modal = document.getElementById('qrModal');
            modal.classList.remove('show');
        }

        function deleteAccount() {
            // Show the custom modal
            const modal = document.getElementById('deleteAccountModal');
            const input = document.getElementById('confirmationInput');
            const confirmBtn = document.getElementById('confirmDeleteBtn');
            
            // Reset modal state
            input.value = '';
            input.classList.remove('error');
            confirmBtn.disabled = true;
            
            // Show modal
            modal.classList.add('show');
            
            // Focus on input
            setTimeout(() => {
                input.focus();
            }, 300);
        }

        function closeDeleteModal() {
            const modal = document.getElementById('deleteAccountModal');
            modal.classList.remove('show');
        }

        function confirmDeleteAccount() {
            const input = document.getElementById('confirmationInput');
            const confirmBtn = document.getElementById('confirmDeleteBtn');
            
            if (input.value === 'DELETE') {
                // Show loading state
                confirmBtn.disabled = true;
                confirmBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Deleting...';
                
                // Make the delete request
                fetch('ajax/delete-account.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showNotification('Account deleted successfully. Redirecting...', 'success');
                        setTimeout(() => {
                            window.location.href = data.redirect || 'index.php';
                        }, 2000);
                    } else {
                        showNotification(data.message || 'Failed to delete account', 'error');
                        // Reset button
                        confirmBtn.disabled = false;
                        confirmBtn.innerHTML = '<i class="fas fa-trash"></i> Delete Account';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showNotification('An error occurred while deleting account', 'error');
                    // Reset button
                    confirmBtn.disabled = false;
                    confirmBtn.innerHTML = '<i class="fas fa-trash"></i> Delete Account';
                });
            } else {
                // Show error state
                input.classList.add('error');
                showNotification('Please type "DELETE" exactly to confirm', 'error');
            }
        }

        // Handle input validation
        document.addEventListener('DOMContentLoaded', function() {
            const input = document.getElementById('confirmationInput');
            const confirmBtn = document.getElementById('confirmDeleteBtn');
            const modal = document.getElementById('deleteAccountModal');
            
            if (input && confirmBtn) {
                input.addEventListener('input', function() {
                    this.classList.remove('error');
                    
                    if (this.value === 'DELETE') {
                        confirmBtn.disabled = false;
                    } else {
                        confirmBtn.disabled = true;
                    }
                });
                
                // Handle Enter key
                input.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter' && !confirmBtn.disabled) {
                        confirmDeleteAccount();
                    }
                });
            }
            
            // Close modal when clicking outside
            if (modal) {
                modal.addEventListener('click', function(e) {
                    if (e.target === modal) {
                        closeDeleteModal();
                    }
                });
            }
            // Close QR when clicking outside
            const qrModal = document.getElementById('qrModal');
            if (qrModal) {
                qrModal.addEventListener('click', function(e) {
                    if (e.target === qrModal) {
                        closeQr();
                    }
                });
            }
            
            // Close modal with Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && modal.classList.contains('show')) {
                    closeDeleteModal();
                }
            });
        });

        // Initialize cart badge
        document.addEventListener('DOMContentLoaded', function() {
            updateCartBadge();
        });
    </script>
</body>
</html>