<?php
require_once 'config/database.php';

echo "<h1>Update Order Status Enum</h1>";

try {
    $db = getDB();
    
    // Check current status values
    echo "<h3>Current order status values:</h3>";
    $stmt = $db->query("SELECT DISTINCT status FROM orders");
    $statuses = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<ul>";
    foreach ($statuses as $status) {
        echo "<li>" . htmlspecialchars($status) . "</li>";
    }
    echo "</ul>";
    
    // Update the enum to include new status
    echo "<h3>Updating order status enum...</h3>";
    
    try {
        // Add the new status to the enum
        $alterSql = "ALTER TABLE orders MODIFY COLUMN status ENUM('pending', 'awaiting_payment', 'processing', 'shipped', 'delivered', 'cancelled') DEFAULT 'pending'";
        $db->exec($alterSql);
        echo "<p>✅ Successfully added 'awaiting_payment' status to orders table</p>";
    } catch (Exception $e) {
        echo "<p>⚠️ Could not modify enum (might already exist): " . $e->getMessage() . "</p>";
    }
    
    // Show updated status values
    echo "<h3>Updated order status values:</h3>";
    $stmt = $db->query("SELECT DISTINCT status FROM orders");
    $statuses = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<ul>";
    foreach ($statuses as $status) {
        echo "<li>" . htmlspecialchars($status) . "</li>";
    }
    echo "</ul>";
    
    // Show current orders with their statuses
    echo "<h3>Current orders and their statuses:</h3>";
    $stmt = $db->query("SELECT order_number, status, payment_method, payment_status, created_at FROM orders ORDER BY created_at DESC LIMIT 10");
    $orders = $stmt->fetchAll();
    
    if (!empty($orders)) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>Order Number</th><th>Status</th><th>Payment Method</th><th>Payment Status</th><th>Created</th></tr>";
        
        foreach ($orders as $order) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($order['order_number']) . "</td>";
            echo "<td>" . htmlspecialchars($order['status']) . "</td>";
            echo "<td>" . htmlspecialchars($order['payment_method']) . "</td>";
            echo "<td>" . htmlspecialchars($order['payment_status']) . "</td>";
            echo "<td>" . htmlspecialchars($order['created_at']) . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>No orders found.</p>";
    }
    
    echo "<h3>✅ Order status update complete!</h3>";
    echo "<p><strong>New Status Meanings:</strong></p>";
    echo "<ul>";
    echo "<li><strong>pending</strong> - Order created, waiting for processing (COD, Bank Transfer)</li>";
    echo "<li><strong>awaiting_payment</strong> - Order created, waiting for online payment completion</li>";
    echo "<li><strong>processing</strong> - Payment confirmed, order being prepared</li>";
    echo "<li><strong>shipped</strong> - Order shipped to customer</li>";
    echo "<li><strong>delivered</strong> - Order delivered to customer</li>";
    echo "<li><strong>cancelled</strong> - Order cancelled</li>";
    echo "</ul>";
    
    echo "<p><a href='admin/pages/orders.php'>Go to Orders Management</a></p>";
    echo "<p><a href='checkout.php'>Test Checkout</a></p>";
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}
?>