<?php
session_start();
require_once 'models/User.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!isset($_FILES['avatar'])) {
    echo json_encode(['success' => false, 'message' => 'No file uploaded']);
    exit();
}

$file = $_FILES['avatar'];

if ($file['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'Upload error']);
    exit();
}

$allowedTypes = ['image/jpeg' => 'jpg', 'image/png' => 'png', 'image/gif' => 'gif'];
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = finfo_file($finfo, $file['tmp_name']);

if (!isset($allowedTypes[$mime])) {
    echo json_encode(['success' => false, 'message' => 'Invalid file type']);
    exit();
}

// Create uploads directory if it doesn't exist
$uploadDir = __DIR__ . '/uploads/avatars/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$extension = $allowedTypes[$mime];
$filename = 'avatar_' . $_SESSION['user_id'] . '_' . time() . '.' . $extension;
$targetPath = $uploadDir . $filename;

if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
    echo json_encode(['success' => false, 'message' => 'Failed to save file']);
    exit();
}

// Build public path
$publicPath = 'uploads/avatars/' . $filename;

// Update user record
$user = new User();
if ($user->updateAvatar($_SESSION['user_id'], $publicPath)) {
    echo json_encode(['success' => true, 'avatar' => $publicPath]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update profile']);
}
?>