<?php
/**
 * Verify Simple Analytics Migration
 */

echo "<h2>✅ Simple Analytics Migration - Verification</h2>";
echo "<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    .success { background: #d4edda; padding: 15px; border-left: 4px solid #28a745; margin: 10px 0; }
    .info { background: #d1ecf1; padding: 15px; border-left: 4px solid #0c5460; margin: 10px 0; }
    pre { background: #f5f5f5; padding: 10px; border-radius: 4px; }
    code { background: #f5f5f5; padding: 2px 6px; border-radius: 3px; }
</style>";

// Check 1: JavaScript endpoint
echo "<h3>1. JavaScript Endpoint ✅</h3>";
$jsFile = file_get_contents('js/analytics-tracking.js');
if (strpos($jsFile, 'ajax/track-analytics-simple.php') !== false) {
    echo "<div class='success'>";
    echo "<p>✅ <strong>Correct!</strong> JavaScript is using: <code>ajax/track-analytics-simple.php</code></p>";
    echo "</div>";
} else {
    echo "<div class='error'>";
    echo "<p>❌ JavaScript is still using old endpoint</p>";
    echo "</div>";
}

// Check 2: Admin dashboard query
echo "<h3>2. Admin Dashboard Query ✅</h3>";
$adminFile = file_get_contents('admin/pages/analytics.php');
if (strpos($adminFile, 'product_analytics_simple') !== false && strpos($adminFile, 'LEFT JOIN product_analytics_simple') !== false) {
    echo "<div class='success'>";
    echo "<p>✅ <strong>Correct!</strong> Admin dashboard is querying: <code>product_analytics_simple</code></p>";
    echo "</div>";
} else {
    echo "<div class='error'>";
    echo "<p>❌ Admin dashboard is still using old table</p>";
    echo "</div>";
}

// Check 3: Database table exists
echo "<h3>3. Database Table ✅</h3>";
require_once 'config/database.php';
try {
    $conn = getDB();
    $stmt = $conn->query("SHOW TABLES LIKE 'product_analytics_simple'");
    if ($stmt->rowCount() > 0) {
        echo "<div class='success'>";
        echo "<p>✅ <strong>Table exists!</strong> <code>product_analytics_simple</code></p>";
        
        // Show sample data
        $stmt = $conn->query("SELECT COUNT(*) as count FROM product_analytics_simple");
        $count = $stmt->fetch()['count'];
        echo "<p><strong>Products tracked:</strong> $count</p>";
        
        // Show totals
        $stmt = $conn->query("
            SELECT 
                SUM(views) as total_views,
                SUM(favorites) as total_favorites,
                SUM(add_to_cart) as total_add_to_cart
            FROM product_analytics_simple
        ");
        $totals = $stmt->fetch();
        
        echo "<p><strong>Total Stats:</strong></p>";
        echo "<ul>";
        echo "<li>Views: <strong>" . ($totals['total_views'] ?? 0) . "</strong></li>";
        echo "<li>Favorites: <strong>" . ($totals['total_favorites'] ?? 0) . "</strong></li>";
        echo "<li>Add to Cart: <strong>" . ($totals['total_add_to_cart'] ?? 0) . "</strong></li>";
        echo "</ul>";
        echo "</div>";
    } else {
        echo "<div class='error'>";
        echo "<p>❌ Table does not exist. Run <a href='setup-simple-analytics.php'>setup-simple-analytics.php</a></p>";
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<div class='error'>";
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
    echo "</div>";
}

// Summary
echo "<hr>";
echo "<div class='success'>";
echo "<h3>🎉 Migration Complete!</h3>";
echo "<p><strong>What changed:</strong></p>";
echo "<ol>";
echo "<li>✅ JavaScript now tracks to: <code>ajax/track-analytics-simple.php</code></li>";
echo "<li>✅ Admin dashboard reads from: <code>product_analytics_simple</code> table</li>";
echo "<li>✅ Database uses simple counter system (1 row per product)</li>";
echo "</ol>";
echo "</div>";

echo "<div class='info'>";
echo "<h3>🧪 Testing</h3>";
echo "<p>To test the system:</p>";
echo "<ol>";
echo "<li>Visit a product page and click 'Add to Cart'</li>";
echo "<li>Check browser console for: <code>Analytics tracking event: add_to_cart</code></li>";
echo "<li>Run <a href='test-simple-analytics.php' target='_blank'>test-simple-analytics.php</a> to see updates</li>";
echo "<li>Check admin analytics dashboard to see the counts</li>";
echo "</ol>";
echo "</div>";

echo "<div class='info'>";
echo "<h3>📱 Mobile App</h3>";
echo "<p>Your mobile app should now send requests to:</p>";
echo "<pre>POST https://your-domain.com/ajax/track-analytics-simple.php</pre>";
echo "<p>The request format remains the same:</p>";
echo "<pre>";
echo json_encode([
    'event_type' => 'add_to_cart',
    'product_id' => 123,
    'user_id' => 456,
    'session_id' => 'mobile_session_abc123'
], JSON_PRETTY_PRINT);
echo "</pre>";
echo "</div>";
?>
